<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Reviews;

use AvengersMG\MGCms2019\App\Cms\Reviews\Repositories\ReviewsInterface;
use AvengersMG\MGCms2019\App\Cms\Reviews\Review;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use AvengersMG\MGCms2019\App\Cms\Reviews\Repositories\ReviewsRepository;

class ReviewsController extends Controller
{
    private $reviewsRepository;

    /**
     * @return
     */
    public function __construct(ReviewsInterface $reviews)
    {
        $this->reviewsRepository = $reviews;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Review::class);

        $reviews = $this->reviewsRepository->list();
        return view('MGCms2019::admin.reviews.index', compact('reviews'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', Review::class);

        /** Buscar las imagenes dentro de la carpeta public/images/reviews del proyecto laravel */
        $images = $this->reviewsRepository->getImages();

        return view('MGCms2019::admin.reviews.create', compact('images'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $return_route = 'reviews.index';

        /* Buscar la autorización */
        $this->authorize('create', Review::class);

        $this->reviewsRepository->create($request->all());

        /* Si el usuario no tiene permiso de listar reseñas, retornar a creación */
        if (Auth::user()->cant('viewAny', Review::class)) {
            $return_route = 'reviews.create';
        }

        return redirect()->route($return_route);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Review $review)
    {
        /* Buscar la autorización */
        $this->authorize('update', $review);

        /** Buscar las imagenes dentro de la carpeta public/images/reviews del proyecto laravel */
        $images = $this->reviewsRepository->getImages();

        return view('MGCms2019::admin.reviews.edit', compact('review', 'images'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Review $review)
    {
        /* Buscar la autorización */
        $this->authorize('update', $review);

        $this->reviewsRepository->update($request->all(), $review);

        /* Si el usuario no tiene permiso de listar reseñas, retornar a edición */
        if (Auth::user()->cant('viewAny', Review::class)) {
            return redirect()->route('reviews.edit', $review->id);
        }

        return redirect()->route('reviews.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Review $review)
    {
        /* Buscar la autorización */
        $this->authorize('delete', $review);

        Storage::disk('MGCms2019')->delete($review->avatar);
        $review->delete();

        return redirect()->back();
    }
}
