<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Restaurants;

use AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service;
use AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Services\ServiceInterface;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ServiceController extends Controller
{
    public $service;

    public function __construct(ServiceInterface $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Service::class);

        $services = $this->service->list();
        return view('MGCms2019::admin.components.restaurants.services.index', compact('services'));
    }

    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', Service::class);

        $services = $this->service->list();
        return view('MGCms2019::admin.components.restaurants.services.create', compact('services'));
    }

    public function store(Request $request)
    {
        $return_route = 'services.index';

        /* Buscar la autorización */
        $this->authorize('create', Service::class);

        $this->service->create($request);

        /* Si el usuario no tiene permiso de listar servicios, retornar a creación */
        if (Auth::user()->cant('viewAny', Service::class)) {
            $return_route = 'services.create';
        }

        return redirect()->route($return_route);
    }

    public function edit(Service $service)
    {
        /* Buscar la autorización */
        $this->authorize('update', $service);

        return view('MGCms2019::admin.components.restaurants.services.edit', compact('service'));
    }

    public function update(Request $request, Service $service)
    {
        /* Buscar la autorización */
        $this->authorize('update', $service);

        $this->service->update($request, $service);

        /* Si el usuario no tiene permiso de listar servicios, retornar a edición */
        if (Auth::user()->cant('viewAny', Service::class)) {
            return redirect()->route('services.edit', $service->id);
        }

        return redirect()->route('services.index');
    }

    public function destroy(Service $service)
    {
        /* Buscar la autorización */
        $this->authorize('delete', $service);

        $service->delete();

        return redirect()->back();
    }
}
