<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Pages;

use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Cms\Pages\Relation;
use AvengersMG\MGCms2019\App\Cms\Sites\Repositories\SiteInterface;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class RelationPagesController extends Controller
{
    /** @var SiteInterface $siteInterface Repositorio de objetos Site */
    private $siteRepository;

    /**
     * Constructor de clase
     * @param SiteInterface $siteInterface Repositorio de objetos Site
     */
    public function __construct(
        SiteInterface $siteInterface
    )
    {
        /* Provisionar controlador */
        $this->siteRepository = $siteInterface;
    }

    public function create(Page $page, $lang)
    {
        /* Buscar la autorización */
        $this->authorize('update', $page);

        $list_pages = $page->all()->pluck('name', 'id');
        return view('MGCms2019::admin.pages.relations.create', compact('page', 'lang', 'list_pages'));
    }

    public function store(Request $request)
    {
        $page = Page::find($request->page_id);

        /* Buscar la autorización */
        $this->authorize('update', $page);

        Relation::create($request->all());

        return redirect()->route('pages.show', [$page->id, $request->lang]);
    }

    public function update(Request $request, Relation $relation)
    {
        $messageSuccess = 'Actualización de relación de página correcta.';
        $messageFailure = 'Ups. Algo salió mal con la actualización de relación de página.';

        /* Página asociada */
        $page = Page::find($relation->page_id);

        /* Buscar la autorización */
        $this->authorize('update', $page);

        /**
         * Bandera de indicación si el usuario puede acceder al listado
         * @var boolean
         */
        $canViewAny = Auth::user()->can('viewAny', [Page::class, $page->site]);

        /**
         * Bandera de indicación si la página pertenece al sitio actual
         * @var boolean
         */
        $isCurrentSite = ($page->site->id == $this->siteRepository->current()->id);

        /**
         * Información de ruta para los casos en que el usuario tenga o no
         * permiso para acceder al listado
         * @var string|mixed[]
         */
        $routeRetorno = ($canViewAny)
            ? ($isCurrentSite)
                ? 'pages.index-from-current'
                : ['pages.index', [$page->site]] /* Establecer respuesta de retorno. Si página pertenece a sitio actual, esconder URL */
            : ['pages.show', [$page->id, $request->lang]]; /* page.show está usado para editar, por lo que comparten el mismo permiso y no es necesario revisar */

        $relation->name = $request->name;
        $relation->related_page = $request->related_page;
        $relation->save();

        if ($request->wantsJson()) {
            return response()->json($messageSuccess, 200);
        }else if($canViewAny){
            /* Establecer respuesta de retorno. Si página pertenece a sitio actual, esconder URL */
            return $this->responseController(true, $routeRetorno, $messageSuccess);
        }

        /* Sólo retornar redirección back() con mensaje */
        return $this->responseController(false, null, $messageSuccess);
    }

    public function destroy(Relation $relation)
    {
        /* Página asociada */
        $page = Page::find($relation->page_id);

        /* Buscar la autorización */
        $this->authorize('update', $page);

        $relation->delete();
        return redirect()->route('pages.show', [$page->id, app()->getLocale()]);
    }
}
