<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Forms;

use AvengersMG\MGCms2019\App\Cms\Forms\Form;
use AvengersMG\MGCms2019\App\Cms\Forms\FormsInterface;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class FormsController extends Controller
{
    protected $model;

    public function __construct(FormsInterface $form)
    {
        $this->model = $form;
    }

    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Form::class);

        $forms = $this->model->list();
        return view('MGCms2019::admin.forms.index', compact('forms'));
    }

    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', Form::class);

        $mails = $this->model->getMails();
        return view('MGCms2019::admin.forms.create', compact('mails'));
    }

    public function store(Request $request)
    {
        $return_route = 'forms.index';

        /* Buscar la autorización */
        $this->authorize('create', Form::class);

        $success = $this->model->create($request);

        if (!$success) {
            return redirect()->back()->withErrors('Completa los campos');
        }

        /* Si el usuario no tiene permiso de listar formas, retornar a creación */
        if (Auth::user()->cant('viewAny', Form::class)) {
            $return_route = 'forms.create';
        }

        return redirect()->route($return_route);
    }

    public function edit(Form $form)
    {
        /* Buscar la autorización */
        $this->authorize('update', $form);

        $mails = $this->model->getMails();
        return view('MGCms2019::admin.forms.edit', compact('form', 'mails'));
    }

    public function update(Request $request, Form $form)
    {
        /* Buscar la autorización */
        $this->authorize('update', $form);

        $success = $this->model->update($request, $form);

        if (!$success) {
            return redirect()->back()->withErrors('Completa los campos');
        }

        /* Si el usuario no tiene permiso de listar formas, retornar a edición */
        if (Auth::user()->cant('viewAny', Form::class)) {
            return redirect()->route('forms.edit', $form->id);
        }

        return redirect()->route('forms.index');
    }

    public function destroy(Form $form)
    {
        /* Buscar la autorización */
        $this->authorize('delete', $form);

        $this->model->delete($form);

        return redirect()->back();
    }
}
