<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Forms;

use AvengersMG\MGCms2019\App\Cms\Forms\FormRequest;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class FormRequestController extends Controller
{
    protected $formRequest;
    protected $view = 'MGCms2019::admin.services.';

    public function __construct(FormRequest $form)
    {
        $this->formRequest = $form;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', FormRequest::class);

        $data = $this->formRequest->all();

        return view($this->view.'index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', FormRequest::class);

        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /* Buscar la autorización */
        $this->authorize('create', FormRequest::class);

        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $service = $this->formRequest->findOrFail($id);

        /* Buscar la autorización */
        $this->authorize('view', $service);

        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = $this->formRequest->findOrFail($id);

        /* Buscar la autorización */
        $this->authorize('update', $service);

        return view($this->view.'edit', compact('service'));
        //dd($service);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $service = $this->formRequest->findOrFail($id);

        /* Buscar la autorización */
        $this->authorize('update', $service);

        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $service = $this->formRequest->findOrFail($id);

        /* Buscar la autorización */
        $this->authorize('delete', $service);

        //
    }
}
