<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Banners;

use AvengersMG\MGCms2019\App\Cms\Banners\Banner;
use AvengersMG\MGCms2019\App\Cms\Banners\Repositories\BannerInterface;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class BannersController extends Controller
{
    /** @var BannerInterface Repositorio de objetos Banner*/
    protected $bannerRepository;

    /**
     * Constructor de controlador
     * @param BannerInterface $bannerRepository Repositorio inyectado
     *                                          para objetos Banner
     * @return void
     */
    public function __construct(BannerInterface $bannerRepository)
    {
        /* Provisionar controlador */
        $this->bannerRepository = $bannerRepository;
    }

    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Banner::class);

        $banners = Banner::all();
        return view('MGCms2019::admin.banners.index', compact('banners'));
    }

    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', Banner::class);

        $pages = $this->bannerRepository->pageNamesByLanguage();
        $pages[''] = '';
        return view('MGCms2019::admin.banners.create', compact('pages'));
    }

    public function store(Request $request)
    {
        $return_route = 'banners.index';

        /* Buscar la autorización */
        $this->authorize('create', Banner::class);

        $banner = $request->all();
        app()->setLocale($banner['locale']);
//        $banner['page_id'] = (array_filter($banner['page_id'])) ? $banner['page_id'][0] : NULL ;
        if (array_key_exists('img', $banner)) {
            $banner['img'] = '/' . $this->bannerRepository->uploadImage($banner['img']);
        }

        $this->bannerRepository->create($banner);

        /* Si el usuario no tiene permiso de listar banners, retornar a creación */
        if (Auth::user()->cant('viewAny', Banner::class)) {
            $return_route = 'banners.create';
        }

        return redirect()->route($return_route);
    }

    public function show(Banner $banner)
    {
        /* Buscar la autorización */
        $this->authorize('view', $banner);

        //
    }

    public function edit(Banner $banner, $lang)
    {
        /* Buscar la autorización */
        $this->authorize('update', $banner);

        app()->setLocale($lang);
        $pages = $this->bannerRepository->pageNamesByLanguage($lang);
        $pages[''] = '';
        return view('MGCms2019::admin.banners.edit', compact('banner', 'pages'));
    }

    public function update(Request $request, Banner $banner)
    {
        /* Buscar la autorización */
        $this->authorize('update', $banner);

        $data = $request->all();
        app()->setLocale($data['locale']);
        if (array_key_exists('img', $data)) {
            $data['img'] = '/' . $this->bannerRepository->uploadImage($data['img']);
        }

        $banner->update($data);

        /* Si el usuario no tiene permiso de listar banners, retornar a edición */
        if (Auth::user()->cant('viewAny', Banner::class)) {
            return redirect()->route('banners.edit', $banner->id);
        }

        return redirect()->route('banners.index');
    }

    public function destroy(Banner $banner)
    {
        /* Buscar la autorización */
        $this->authorize('delete', $banner);

        Storage::disk('MGCms2019')->delete($banner->img);
        $banner->delete();
        return redirect()->back();
    }

    /**
     * Es un llamado por ajx.
     * el metodo esta en adminCustom.js
     * y se utiliza para la creacion de baners
     * al  hacer el cambio del lenguaje
     *
     * NOTA: Este método es un ayudante para la creación y, por tanto,
     * requiere los permisos de creación de banners
     *
     * @param   string          $lang      Lenguaje de las páginas que
     *                                     se quieren retornar
     * @return  Response|array             ['id' => 'nombre de la página']
     */
    public function urls($lang)
    {
        app()->setLocale($lang);

        /* Buscar la autorización */
        $this->authorize('create', Banner::class);

        $pages = $this->bannerRepository->pageNamesByLanguage($lang);
        $pages[''] = '';

        return $pages;
    }
}
