<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Availability;

use AvengersMG\MGCms2019\App\Cms\Availabilities\Availability;
use AvengersMG\MGCms2019\App\Cms\Availabilities\AvailabilitiesLogEntry;
use AvengersMG\MGCms2019\App\Cms\Availabilities\Exceptions\AvailabilityException;
use AvengersMG\MGCms2019\App\Cms\Availabilities\Repositories\AvailabilityInterface;
use AvengersMG\MGCms2019\App\Cms\Availabilities\Request\UploadAvailabilityRequest;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use AvengersMG\MGCms2019\App\Imports\AvailabilityImport;
use Carbon\Carbon;
use function Couchbase\defaultDecoder;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AvailabilityController extends Controller
{
    /** @var AvailabilityInterface Repositorio de objetos Availability */
    protected $availableRepository;

    /**
     * Constructor de controlador
     *
     * @param AvailabilityInterface $available Repositorio de objetos Availability
     * @return void
     */
    public function __construct(AvailabilityInterface $available)
    {
        /* Provisionar el controlador */
        $this->availableRepository = $available;
    }

    /**
     * Método público de muestreo y paginación de objetos Availability
     *
     * @param  Request  $request La información de solicitud
     * @return Response          Carga de vista de listado
     */
    public function index(Request $request)
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Availability::class);

        /* Paginar y recuperar vínculos para formateo */
        $fechas = $this->availableRepository->paginate(10);
        /* Obtener el primer de los últimos registros */
        $latestChange = AvailabilitiesLogEntry::latest()->first();
        $paginate = $fechas->links();

        /* Responder a petición JSON */
        if ($request->isJson()) {
            return response()->json($fechas);
        }

        /* Petición web. Cargar vista */
        return view('MGCms2019::admin.availability.index', compact('fechas', 'paginate', 'latestChange'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        /* Permiso no disponible */

        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * NOTA: Validación en UploadAvailabilityRequest@rules
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(UploadAvailabilityRequest $request)
    {
        /* Buscar la autorización */
        $this->authorize('updateAll', Availability::class);

        try {
            $this->availableRepository->createAvailabilitiesFromXLSFileRequest($request);
        } catch (AvailabilityException $ae) {
            /* Error en el archivo. Abortar de acuerdo con la petición e informar al usuario */
            abort(400, $ae->getMessage()); /* 400: Bad Request */
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        /* Permiso no disponible */

        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        /* Permiso no disponible */

        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        /* Permiso no disponible */

        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        /* Permiso no disponible */

        //
    }
}
