<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend;

use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    public function __invoke(Request $request)
    {
        $user = Auth::user();

        /** @var mixed Sitio actual. Si null, entonces no hay sitios */
        $site = Site::current();

        if ($user->can('viewAny', Site::class)) {
            return redirect()->route('sites.index');
        } else if(!is_null($site)) {
            if ($user->can('viewAny', [Page::class, $site])) {
                /* Usuario no debe ver sitios. Redirigir a lista de páginas de sitio actual */
                return redirect()->route('pages.index-from-current');
            }
        }

        /* Ningún criterio aplica: Vista general de Dashboard */
        return view('MGCms2019::admin.index');
    }
}
