<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Accommodations;

use AvengersMG\MGCms2019\App\Cms\Accommodations\Categories\CategoryInterface;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Categories\Request\CategoryRequest;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Category;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CategoriesController extends Controller
{
    private $category;
    protected $view;
    /**
     * [__construct CategoryController]
     * @param CategoryInterface $category [contine la inyección del la interfaz del repositorio]
     */
    public function __construct(CategoryInterface $category)
    {
        $this->category = $category;
        $this->view = 'MGCms2019::admin.components.accommodations.categories.';
    }
    /**
     * [index Método para listar categorías]
     * @return Response retorna a la vista index de categorías
     * $categories contiene las categorías existentes
     */
    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Category::class);

        $categories = $this->category->list();
        return view($this->view.'index', compact('categories'));
    }
    /**
     * [create]
     * @return Response retorna la vista de crear categorías
     */
    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', Category::class);

        return view($this->view.'create');
    }
    /**
     * [store resive la data proveniente de la vista]
     * @param  CategoryRequest $request Contiene los datos que son envíados desde la vita del formulario
     * @return Response                   Uns vez creado el registro redirige a la vista index de las categorías
     */
    public function store(CategoryRequest $request)
    {
        $return_route = 'categories.index';

        /* Buscar la autorización */
        $this->authorize('create', Category::class);

        // crea el registro desde el método create que es heredado desde CategoryInterface que a la vez es heredado desde BaseRepository
        $this->category->create($request->all());

        /* Si el usuario no tiene permiso de listar categorías, retornar a creación */
        if (Auth::user()->cant('viewAny', Category::class)) {
            $return_route = 'categories.create';
        }

        return redirect()->route($return_route);
    }
    /**
     * [edit description]
     * @param  Category $category [description]
     * @return [type]             [description]
     */
    public function edit(Category $category)
    {
        /* Buscar la autorización */
        $this->authorize('update', $category);

        return view('MGCms2019::admin.components.accommodations.categories.edit', compact('category'));
    }
    /**
     * [update actualiza un registro de categorías]
     * @param  CategoryRequest $request  Contiene la información proveniente del formulario de la vista con los datos ya validados
     * @param  Category        $category Contiene el modelo del registro que será actualizado
     * @return Response        Redirige a la vista index de categorías
     */
    public function update(CategoryRequest $request, Category $category)
    {
        /* Buscar la autorización */
        $this->authorize('update', $category);

        // Actualiza actualiza el registro enviado desde la vista mediante el método update de eloquent
        $this->category->update($request, $category);

        /* Si el usuario no tiene permiso de listar categorías, retornar a edición */
        if (Auth::user()->cant('viewAny', Category::class)) {
            return redirect()->route('categories.edit', $category->id);
        }

        /* Usuario puede listar */
        return redirect()->route('categories.index');
    }
    /**
     * [destroy Método de eliminación de registros]
     * @param  Category $category Regístro que será eliminado
     * @return Response         Redirige a la vista indes de categorías
     */
    public function destroy(Category $category)
    {
        /* Buscar la autorización */
        $this->authorize('delete', $category);

        /* Elimina el registro enviado a través de la vista mediante el método delete de eloquent */
        $category->delete();

        return redirect()->back();
    }
}
