<?php

namespace AvengersMG\MGCms2019\App\Http\Controllers\Backend\Accommodations;

use AvengersMG\MGCms2019\App\Cms\Accommodations\Amenities\AmenityInterface;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Amenities\Request\AmenityRequest;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Amenities\Request\UpdateAmenityRequest;
use AvengersMG\MGCms2019\App\Cms\Accommodations\Amenity;
use AvengersMG\MGCms2019\App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AmenitiesController extends Controller
{
    /**
     * [$amenity contiene el repositorio de amenidades]
     * @var [variable protegida]
     */
    protected $amenity;
    public $view;
    /**
     * [__construct contructor de clase]
     * @param AmenityInterface $amenity contiene la inyeccción de AmenityInterface
     */
    public function __construct(AmenityInterface $amenity)
    {
        $this->amenity = $amenity;
        $this->view = 'MGCms2019::admin.components.accommodations.amenities.';
    }
    /**
     *
     * @return Response Dirigue a la vista index de amanidades /admin/amenities
     */
    public function index()
    {
        /* Buscar la autorización */
        $this->authorize('viewAny', Amenity::class);

        /* obtiene todas las amenidades existentes */
        $amenities = $this->amenity->list();
        /* retorna la vista y envía los registros de amenidades obtenidos en $amenities */
        return view($this->view.'index', compact('amenities'));
    }
    /**
     *
     * @return Response Retorna la vista de create
     */
    public function create()
    {
        /* Buscar la autorización */
        $this->authorize('create', Amenity::class);

        return view($this->view.'create');
    }
    /**
     * [store Método de guarddo de amenidades]
     * @param  Request $request Contiene campos envíados desde la vista del formulario
     * @return Response          retorna la vista index de las amenidades
     */
    public function store(AmenityRequest $request)
    {
        $return_route = 'amenities.index';

        /* Buscar la autorización */
        $this->authorize('create', Amenity::class);

        //dd($request->all());
        /* obtiene los datos del $request para ser creados en la db mediante el método create del repositorio de amenidades AmenityRepository@create */
        $this->amenity->create($request);

        /* Si el usuario no tiene permiso de listar amenidades, retornar a creación */
        if (Auth::user()->cant('viewAny', Amenity::class)) {
            $return_route = 'amenities.create';
        }

        return redirect()->route($return_route);
    }
    /**
     * edit método de edición de amenidades
     * @param  Amenity $amenity Contiene el modelo de amenidades
     * @return Response           retorna la vista de idición de registros y pasa el modelo de amenidades a la vista */

    public function edit(Amenity $amenity)
    {
        /* Buscar la autorización */
        $this->authorize('update', $amenity);

        return view($this->view.'edit', compact('amenity'));
    }
    /**
     * update Método para la actualización de registros
     * @param  Request $request contiene la información de los campos del formulario de la vista
     * @param  Amenity $amenity contiene el modelo de la amenidad que se asigna al registro a ser actualizado
     * @return Response actualiza la amenidad mediante el método update del repositorio de amenidades AmenityRepository@update
     */
    public function update(UpdateAmenityRequest $request, Amenity $amenity)
    {
        /* Buscar la autorización */
        $this->authorize('update', $amenity);

        $this->amenity->update($request, $amenity);

        /* Si el usuario no tiene permiso de listar amenidades, retornar a edición */
        if (Auth::user()->cant('viewAny', Role::class)) {
            return redirect()->route('amenities.edit', $amenity->id);
        }

        /* Usuario puede retornar a listado de amenidades */
        return redirect()->route('amenities.index');
    }
    /**
     * destroy método para eliminación de amenidades
     * @param  Amenity $amenity Modelo de amenidades para identifca el archivo que será eliminado
     * @return Response       Dirige a la vista index de amenidades
     */
    public function destroy(Amenity $amenity)
    {
        /* Buscar la autorización */
        $this->authorize('delete', $amenity);

        /* Elimina el dato corespondiente mediante el método de eloquent delete() */
        $amenity->delete();

        /* Retornar a la página original */
        return redirect()->back();
    }
}
