<?php

namespace AvengersMG\MGCms2019\App\Console\Commands;

use AvengersMG\MGCms2019\Database\Seeds\DatabaseSeeder;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class SeedDatabase extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mgcms2019:seed';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Llenar la base de datos con valores iniciales para usar el paquete AvengersMG\\MGCms2019';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        /* Informar de inicio */
        $this->info('Poblando tablas...');

        /* Correr seeds */
        Artisan::call('db:seed', [
            '--database' => config('database.default'),
            '--class' => DatabaseSeeder::class,
            '--force' => true,
        ]);

        /* Informar de finalizado */
        $this->info('Tablas pobladas.');

        /* Correr seeds */
        Artisan::call('mgcms2019:publish-frontend');
    }
}
