<?php

namespace AvengersMG\MGCms2019\App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class RollbackFromPackage extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mgcms2019:rollback-from-package';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Deshacer preparativos de base de datos para uso del paquete AvengersMG\\MGCms2019';

    /*
        Propiedades para mantener el código DRY
     */
    private $nameSpaceAppend = 'AvengersMG\\MGCms2019\\';
    private $originalNameSpace = 'App\\Cms\\';
    private $addSoftDeleteAndUsersMigration = '2018_07_17_142107_add_softdeletes_and_username_to_users';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        /* Formatear criterio de búsqueda */
        $currentNameSpaceSearch = addslashes($this->nameSpaceAppend) . '%';

        /* Informar de inicio */
        $this->info('Deshaciendo cambios en base de datos actual...');

        DB::beginTransaction();

        try {
            /* Eliminar los registros de las migraciones hechas por el paquete */
            DB::table('migrations')->where('migration', $this->addSoftDeleteAndUsersMigration)->delete();

            /* Retornar espacios de nombre originales en tablas polimórficas: mediafiles */
            DB::statement("UPDATE mediafiles SET mediafilable_type = SUBSTRING(mediafilable_type, (LENGTH(:nameSpaceAppend) + 1), LENGTH(mediafilable_type)) where mediafilable_type LIKE :currentNameSpace", [
                'nameSpaceAppend' => $this->nameSpaceAppend,
                'currentNameSpace' => $currentNameSpaceSearch
            ]);

            /* Retornar espacios de nombre originales en tablas polimórficas: model_has_roles */
            DB::statement("UPDATE model_has_roles SET model_type = SUBSTRING(model_type, (LENGTH(:nameSpaceAppend) + 1), LENGTH(model_type)) where model_type LIKE :currentNameSpace", [
                'nameSpaceAppend' => $this->nameSpaceAppend,
                'currentNameSpace' => $currentNameSpaceSearch
            ]);

            /* Ejecutar cambios */
            DB::commit();
        } catch (Exception $e) {
            /* Deshacer cambios */
            DB::rollback();

            /* Error al ejecutar */
            $this->error('No fue posible deshacer los cambios: ' . $e->getMessage());
            return;
        }

        /* Informar de finalizado */
        $this->info('Proceso terminado exitosamente.');
    }
}
