<?php

namespace AvengersMG\MGCms2019\App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;

class PublishFrontend extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mgcms2019:publish-frontend';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Copiar los recursos dummy desde el paquete AvengersMG\\MGCms2019 al proyecto actual';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        if (!File::isDirectory(resource_path('views/emails')) && !File::isDirectory(resource_path('views/templates')) && !File::isDirectory(resource_path('views/layouts')) && !File::isDirectory(resource_path('views/partials'))) {
            /* Intentando copiar archivos necesarios para templates y layouts */
            $this->info('Copiando archivos necesarios para templates y layouts...');

            /* Publicar recursos */
            Artisan::call('vendor:publish', [
                '--tag' => 'frontend',
            ]);

            /* Informar de copia exitosa */
            $this->info('Archivos copiados.');
        } else {
            /* Algunos archivos ya existen. Informar y terminar */
            $this->info('Algunos de los directorios ya existen: Los archivos para frontend no serán copiados.');
        }
    }
}
