<?php

namespace AvengersMG\MGCms2019\App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class MigrateToPackage extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mgcms2019:migrate-to-package';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Crear preparativos para que la base de datos esté lista para usar el paquete AvengersMG\\MGCms2019';

    /*
        Propiedades para mantener el código DRY
     */
    private $nameSpaceAppend = 'AvengersMG\\MGCms2019\\';
    private $originalNameSpace = 'App\\Cms\\';
    private $addSoftDeleteAndUsersMigration = '2018_07_17_142107_add_softdeletes_and_username_to_users';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        /* Formatear criterio de búsqueda */
        $originalNameSpaceSearch = addslashes($this->originalNameSpace) . '%';

        /* Informar de inicio */
        $this->info('Ejecutando cambios en base de datos actual...');

        DB::beginTransaction();

        try {
            /* Verificar que no fue insertado antes */
            $isInserted = DB::table('migrations')->where('migration', $this->addSoftDeleteAndUsersMigration)->count() > 0;

            /* Insertar si no existe */
            if (!$isInserted) {
                DB::table('migrations')->insert([
                    'migration' => $this->addSoftDeleteAndUsersMigration,
                    'batch' => 1
                ]);
            }

            /* Actualizar espacios de nombre en tablas polimórficas: mediafiles */
            DB::statement("UPDATE mediafiles SET mediafilable_type = CONCAT(:nameSpaceAppend, mediafilable_type) where mediafilable_type LIKE :originalNameSpace", [
                'nameSpaceAppend' => $this->nameSpaceAppend,
                'originalNameSpace' => $originalNameSpaceSearch
            ]);

            /* Actualizar espacios de nombre en tablas polimórficas: model_has_roles */
            DB::statement("UPDATE model_has_roles SET model_type = CONCAT(:nameSpaceAppend, model_type) where model_type LIKE :originalNameSpace", [
                'nameSpaceAppend' => $this->nameSpaceAppend,
                'originalNameSpace' => $originalNameSpaceSearch
            ]);

            /* Ejecutar cambios */
            DB::commit();
        } catch (Exception $e) {
            /* Deshacer cambios */
            DB::rollback();

            /* Error al ejecutar */
            $this->error('No fue posible hacer los cambios: ' . $e->getMessage());
            return;
        }

        /* Informar de finalizado */
        $this->info('Proceso terminado exitosamente.');
    }
}
