<?php

namespace AvengersMG\MGCms2019\App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use AvengersMG\MGCms2019\App\Console\Commands\SeedDatabase;

class MigrateDatabase extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mgcms2019:migrate';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Solamente crear las tablas necesarias para usar el paquete AvengersMG\\MGCms2019';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        /* Informar de inicio */
        $this->info('Ejecutando migraciones...');

        Artisan::call('migrate', [
            '--database' => config('database.default'),
            '--force' => true,
        ]);

        /* Informar de finalizado */
        $this->info('Migraciones ejecutadas exitosamente.');
    }
}
