<?php

namespace AvengersMG\MGCms2019\App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class Flush extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mgcms2019:flush';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Eliminar los datos compilados y la caché de configuración';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        /* Informar de inicio */
        $this->info('Eliminando archivos compilados y limpiando caché de configuración...');

        Artisan::call('clear-compiled');
        Artisan::call('config:cache');

        /* Informar de finalizado */
        $this->info('Proceso finalizado correctamente.');
    }
}
