<?php

namespace AvengersMG\MGCms2019\App\Cms\Users;

use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Cms\Users\Repositories;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use NotificationChannels\WebPush\HasPushSubscriptions;

use Illuminate\Support\Str;

class User extends Authenticatable //implements UserInterface
{
    use HasRoles, Notifiable, SoftDeletes, HasApiTokens, HasPushSubscriptions;

    protected $guard_name = 'web';

    protected $fillable = [
        'name', 'email', 'username', 'password',
    ];


    protected $hidden = [
        'password', 'remember_token',
    ];

    /* Relaciones a cargar con el modelo */
    protected $with = [
        'sites',
    ];

    protected $dates = ['deleted_at'];


    public function sites()
    {
        return $this->belongsToMany(Site::class, 'site_user');
    }

    public function mediafiles()
    {
        return $this->morphMany(Mediafile::class, 'mediafileable');
    }

    /**
     * Setters
     */

    public function setNameAttribute($value)
    {
        $this->attributes['name'] = mb_strtolower($value);
    }

    public function setUsernameAttribute($value)
    {
        $this->attributes['username'] = Str::slug(mb_strtolower($value), '');
    }

    public function setPasswordAttribute($value)
    {
        $this->attributes['password'] = bcrypt($value);
    }
}
