<?php

namespace AvengersMG\MGCms2019\App\Cms\Users\Requests;

use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $data = $this->request->all();
        $user = User::find($data['id']);
        return [
            'name' => 'required',
            'username' => ['required', Rule::unique('users', 'username')->ignore($user->id)],
            'email' => ['required', Rule::unique('users', 'email')->ignore($user->id)],
            'role' => 'sometimes|exists:roles,name',
            'password' => 'nullable|min:6|confirmed',
            'sites' => 'sometimes|array',
            'sites.*' => 'required_with:sites|exists:sites,id',
        ];
    }
}
