<?php

namespace AvengersMG\MGCms2019\App\Cms\Users\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'username' => 'required|unique:users,username',
            'email' => 'unique:users,email',
            'role' => 'required|exists:roles,name',
            'password' => 'required|min:6|confirmed',
            'sites.*' => 'required|exists:sites,id',
        ];
    }
}
