<?php

namespace AvengersMG\MGCms2019\App\Cms\Users\Policies;

use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class UserPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the user list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar los usuarios */
        return $user->can('listar_usuarios');
    }

    /**
     * Determine whether the user can view the user.
     *
     * @param  User $user
     * @param  User $targetUser
     * @return mixed
     */
    public function view(User $user, User $targetUser)
    {
        /* Permitir si puede ver todos los usuarios o si es su propio perfil */
        return $user->can('ver_usuarios') || ($user->can('ver_usuario_propio') && ($user->id === $targetUser->id));
    }

    /**
     * Determine whether the user can create users.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear usuarios */
        return $user->can('crear_usuarios');
    }

    /**
     * Determine whether the user can update the user.
     *
     * @param  User $user
     * @param  User $targetUser
     * @return mixed
     */
    public function update(User $user, User $targetUser)
    {
        /* Permitir si puede actualizar los usuarios o si es su propio perfil */
        return $user->can('editar_usuarios') || ($user->can('editar_usuario_propio') && ($user->id === $targetUser->id));
    }

    /**
     * Determine whether the user can update their own role.
     *
     * @param  User $user
     * @param  User $targetUser
     * @return mixed
     */
    public function updateOwnRole(User $user, User $targetUser)
    {
        /* Permitir si puede actualizar los usuarios o si es su propio perfil */
        return $user->can('editar_usuarios') || ($user->can('editar_rol_propio') && ($user->id === $targetUser->id));
    }

    /**
     * Determine whether the user can update their own site assignations.
     *
     * @param  User $user
     * @return mixed
     */
    public function updateOwnSites(User $user)
    {
        /* Permitir si puede actualizar sus asignaciones de sitios */
        return $user->can('editar_usuarios') || $user->can('editar_sitios_de_usuario_propio');
    }

    /**
     * Determine whether the user can delete the user.
     *
     * @param  User $user
     * @param  User $targetUser
     * @return mixed
     */
    public function delete(User $user, User $targetUser)
    {
        /* Permitir si puede eliminar los usuarios y o es el mismo usuario */
        return $user->can('eliminar_usuarios') && ($user->id !== $targetUser->id);
    }
}
