<?php

namespace AvengersMG\MGCms2019\App\Cms\Socialmedias\Request;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSocialmediaRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        /* Retorna los datos a actualizar ya validados para ser procesados por el método store */
        return [
            'description' => 'required|unique:socialmedias,description,' . $this->route('socialmedia')->id,
            'body' => 'sometimes|nullable|max:191',
        ];
    }
}
