<?php

namespace AvengersMG\MGCms2019\App\Cms\Socialmedias\Repositories;

use AvengersMG\MGCms2019\App\Cms\Socialmedias\Repositories\SocialmediaInterface;
use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use AvengersMG\MGCms2019\App\Cms\Socialmedias\Socialmedia;

class SocialmediaRepository extends BaseRepository implements SocialmediaInterface
{
    public function __construct()
    {
        parent::__construct(Socialmedia::class);
    }

    /**
     * Método público para crear un modelo de red social, filtrando bajo
     * criterios necesarios
     *
     * @param  Request $params Petición de cambio
     * @param  string $model   Modelo a modificar
     * @return void
     */
    public function create($params)
    {
        call_user_func("{$this->model}::create", [
            'description' => $params['description'],
            'body' => $params['body']
        ]);
    }

    /**
     * Método público para actualizar un modelo de red social, filtrando bajo
     * criterios necesarios
     *
     * @param  Request $params Petición de cambio
     * @param  string $model   Modelo a modificar
     * @return void
     */
    public function update($params, $model = null)
    {
        $model->description = $params->description;
        $model->body = $params->body;
        $model->save();
    }
}
