<?php

namespace AvengersMG\MGCms2019\App\Cms\Sites\Repositories;

use \Exception;
use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;

class SiteRepository extends BaseRepository implements SiteInterface
{
    public function __construct()
    {
        parent::__construct(Site::class);
    }

    public function createSite(Request $request)
    {
        $path = '';
        if (array_key_exists('logo', $request->all())) {
            $logo = $request->file('logo')->getClientOriginalName();
            $ext = $request->file('logo')->getExtension();
            $path = 'mediafiles/sites/'.Str::slug(ucfirst($request->name), '-').'/logo';
            $request->file('logo')->storeAs($path, Str::slug($logo).'.'.$ext, 'MGCms2019');
        }

        $params = [
            'domain' => $request->domain,
            'name' => $request->name,
            'logo' => ($path) ? $path : null,
        ];

        $site = $this->create($params);

        $site->translateOrNew('en')->meta_title = $request->meta_title;
        $site->translateOrNew('en')->meta_description = $request->meta_description;
        $site->translateOrNew('en')->phone = $request->phone;
        $site->translateOrNew('en')->schema = $request->schema;
        $site->save();
    }

    public function updateSite(Request $request, Model $site)
    {
        app()->setLocale($request->lang);

        if ($request->has('logo')) {
            $logo = $request->logo->getClientOriginalName();
            $path = 'sites/'.str_slug(ucfirst($request->name)).'/logo';
            $request->file('logo')->storeAs($path, $logo, 'MGCms2019');

            $site->name = $request->name;
            /* Actualizar sólo si existe */
            if ($request->has('domain')) {
                $site->domain = $request->domain;
            }
            $site->logo = "{$path}/{$logo}";
            $site->save();

            return $site;
        }

        /* Editar sólo si etán definidas */
        if ($request->has('socialmedias')) {
            /* Actualizar las redes sociales */
            $site->socialmedias()->sync(collect($request->socialmedias)->mapWithKeys(function ($url, $socialmediaId) {
                return ["$socialmediaId" => ['url' => $url]];
            })->all());

            /* Terminar edición */
            return $site;
        }

        return parent::update($request, $site);
    }

    public function getThemes()
    {
        $dirs = [];
        $dir = resource_path('views');
        try {
            if ($folder = opendir($dir)) {
                while (($file = readdir($folder)) !== false) {
                    if ($file != '.' && $file != '..') {
                        if (is_dir("{$dir}/$file")) {
                            $dirs[$file] = $file;
                        }
                    }
                }
            }
        } catch (Exception $e) {
            return [];
        }

        return $dirs;
    }


    public function saveImage($img, $name)
    {
        $logo = $img->getClientOriginalName();
        $path = 'sites/'.str_slug(ucfirst($name), '-').'/logo';
        $img->file('logo')->storeAs($path, str_slug($logo), 'MGCms2019');
        return $path;
    }
}
