<?php

namespace AvengersMG\MGCms2019\App\Cms\Sites\Policies;

use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class SitePolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the site list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todos los sitios */
        return $user->can('listar_sitios');
    }

    /**
     * Determine whether the user can view the site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function view(User $user, Site $site)
    {
        /* Permitir si puede ver todos los sitios o si es de un sitio asignado */
        return $user->can('ver_sitios') || ($user->can('ver_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can create sites.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear sitios */
        return $user->can('crear_sitios');
    }

    /**
     * Determine whether the user can update the site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function update(User $user, Site $site)
    {
        /* Permitir si puede actualizar todos los sitios o si es un sitio asignado */
        return $user->can('editar_sitios') || ($user->can('editar_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can update the site's domain.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function updateDomain(User $user)
    {
        /* Permitir si tiene cualquiera de los dos permisos */
        return $user->can('editar_sitios') || $user->can('editar_dominio_de_sitios');
    }

    /**
     * Determine whether the user can update their own site's domain.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function updateOwnDomain(User $user, Site $site)
    {
        /* Permitir si puede actualizar todos los sitios o si es un sitio asignado */
        return $user->can('editar_sitios') || ($user->can('editar_dominio_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can delete the site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function delete(User $user, Site $site)
    {
        /* Permitir si puede eliminar todos los sitios o si es un sitio asignado */
        return $user->can('eliminar_sitios') || ($user->can('eliminar_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }
}
