<?php
/**
 * Created by PhpStorm.
 * User: MAC_82_MKT_Full_Stack
 * Date: 29/08/18
 * Time: 12:54
 */

namespace AvengersMG\MGCms2019\App\Cms\Roles\Repositories;

use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use Spatie\Permission\Models\Role;

class RoleRepository extends BaseRepository implements RoleInterface
{
    public function __construct()
    {
        parent::__construct(Role::class);
    }

    public function create($params)
    {
        $params['name'] = str_slug($params['name'], '_');
        return parent::create($params);
    }

    public function update($params, $model = '')
    {
        $params->name = str_slug($params->name, '_');
        $model->name = $params->name;
        $model->save();

        return $model;
    }
}
