<?php

namespace AvengersMG\MGCms2019\App\Cms\Roles\Policies;

use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Spatie\Permission\Models\Role;

class RolePolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the role list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todos los roles */
        return $user->can('listar_roles');
    }

    /**
     * Determine whether the user can view the role.
     *
     * @param  User $user
     * @param  Role $role
     * @return mixed
     */
    public function view(User $user, Role $role)
    {
        /* Permitir si puede ver todos los roles */
        return $user->can('ver_roles');
    }

    /**
     * Determine whether the user can create roles.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear roles */
        return $user->can('crear_roles');
    }

    /**
     * Determine whether the user can update the role.
     *
     * @param  User $user
     * @param  Role $role
     * @return mixed
     */
    public function update(User $user, Role $role)
    {
        /* Permitir si puede actualizar todos los roles */
        return $user->can('editar_roles');
    }

    /**
     * Determine whether the user can delete the role.
     *
     * @param  User $user
     * @param  Role $role
     * @return mixed
     */
    public function delete(User $user, Role $role)
    {
        /* Permitir si puede eliminar todos los roles */
        return $user->can('eliminar_roles');
    }
}
