<?php

/**
 * Created by PhpStorm.
 * User: MAC_82_MKT_Full_Stack
 * Date: 24/04/19
 * Time: 10:00
 */

namespace AvengersMG\MGCms2019\App\Cms\Reviews\Repositories;

use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use AvengersMG\MGCms2019\App\Cms\Reviews\Review;
use Illuminate\Support\Facades\Storage;

class ReviewsRepository extends BaseRepository implements ReviewsInterface
{
    public function __construct()
    {
        parent::__construct(Review::class);
    }

    public function create($params)
    {
        call_user_func("{$this->model}::create", $params);
    }

    public function update($params, $model = null)
    {
        // if (array_key_exists('avatar', $params)) {
        //     Storage::disk('MGCms2019')->delete($model->avatar);
        //     $params['avatar'] = $this->storeImage($params['avatar']);
        // }

        $model->update($params);
    }

    public function storeImage($img)
    {
        $id = $this->list()->count() + 1;

        $name = explode('.', $img->getClientOriginalName());
        array_pop($name);
        $name = $this->getName($name);
        $ext = $img->getClientOriginalExtension();
        $full_name = $name . '.' . $ext;

        $path = $img->storeAs('mediafiles/reviews/' . date('Y') . '/' . date('m'), $id . '_' . $full_name, 'MGCms2019');

        return $path;
    }

    public function getName($array)
    {
        $name = '';
        foreach ($array as $item) {
            $name = $name . $item;
        }

        return $name;
    }

    /**
     * Metodo para traer las imagenes de las plataformas de donde se buscan reviews
     */

    public function getImages()
    {
        $images = [];
        $dir =  '/public/images/reviews';
        if (!file_exists(base_path() . $dir))
            mkdir(base_path() . $dir);

        try {
            $files = scandir(base_path() . $dir);
            foreach ($files as $i => $layout) {
                /** Eliminamos directorios */
                if (!is_dir($layout))
                    /** Array con el nombre de los archivos */
                    array_push($images, ['/images/reviews/' . $layout => $layout]);
            }
        } catch (Exception $e) {
            return [];
        }

        return collect($images)->collapse();
    }

    /**
     * Metodo para traer los reviews que se mostraran en el sitio
     * var lang Lenaguaje del sitio  
     */
    public function getReviews($lang)
    {
        $reviews = $this->list()->where('locale', $lang);

        /** Si hay mas de 5 reviews hacemos un random para traer solo 5 */
        if ($reviews->count() > 5) {
            return $reviews->random(5);
        }

        return $reviews;
    }
}
