<?php

namespace AvengersMG\MGCms2019\App\Cms\Reviews\Policies;

use AvengersMG\MGCms2019\App\Cms\Reviews\Review;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class ReviewPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the review list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todas las reseñas */
        return $user->can('listar_resenas');
    }

    /**
     * Determine whether the user can view the review.
     *
     * @param  User $user
     * @param  Review $review
     * @return mixed
     */
    public function view(User $user, Review $review)
    {
        /* Permitir si puede ver todas las reseñas */
        return $user->can('ver_resenas');
    }

    /**
     * Determine whether the user can create reviews.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear reseñas */
        return $user->can('crear_resenas');
    }

    /**
     * Determine whether the user can update the review.
     *
     * @param  User $user
     * @param  Review $review
     * @return mixed
     */
    public function update(User $user, Review $review)
    {
        /* Permitir si puede actualizar todas las reseñas */
        return $user->can('editar_resenas');
    }

    /**
     * Determine whether the user can delete the review.
     *
     * @param  User $user
     * @param  Review $review
     * @return mixed
     */
    public function delete(User $user, Review $review)
    {
        /* Permitir si puede eliminar todas las reseñas */
        return $user->can('eliminar_resenas');
    }
}
