<?php
/**
 * Created by PhpStorm.
 * User: MAC_82_MKT_Full_Stack
 * Date: 05/09/18
 * Time: 11:01
 */

namespace AvengersMG\MGCms2019\App\Cms\Permissions\Repositories;

use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use Spatie\Permission\Models\Permission;

class PermissionRepository extends BaseRepository implements PermissionInterface
{
    public function __construct()
    {
        parent::__construct(Permission::class);
    }

    public function create($params)
    {
        $params['name'] = str_slug($params['name'], '_');
        return parent::create($params);
    }

    public function update($params, $model = '')
    {
        $params->name = str_slug($params->name, '_');
        $model->name = $params->name;
        $model->save();

        return $model;
    }
}
