<?php

namespace AvengersMG\MGCms2019\App\Cms\Permissions\Policies;

use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Spatie\Permission\Models\Permission;

class PermissionPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the permission list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todos los permisos */
        return $user->can('listar_permisos');
    }

    /**
     * Determine whether the user can view the permission.
     *
     * @param  User $user
     * @param  Permission $permission
     * @return mixed
     */
    public function view(User $user, Permission $permission)
    {
        /* Permitir si puede ver todos los permisos */
        return $user->can('ver_permisos');
    }

    /**
     * Determine whether the user can create permissions.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear permisos */
        return $user->can('crear_permisos');
    }

    /**
     * Determine whether the user can update the permission.
     *
     * @param  User $user
     * @param  Permission $permission
     * @return mixed
     */
    public function update(User $user, Permission $permission)
    {
        /* Permitir si puede actualizar todos los permisos */
        return $user->can('editar_permisos');
    }

    /**
     * Determine whether the user can delete the permission.
     *
     * @param  User $user
     * @param  Permission $permission
     * @return mixed
     */
    public function delete(User $user, Permission $permission)
    {
        /* Permitir si puede eliminar todos los permisos */
        return $user->can('eliminar_permisos');
    }
}
