<?php

namespace AvengersMG\MGCms2019\App\Cms\Pages\Request;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UploadFilePageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->instance()->ajax();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'file' => 'required|file',
            'lang' => [
                'required',
                Rule::in(app()->make('translatable.locales')->all())
            ]
        ];
    }
}
