<?php

namespace AvengersMG\MGCms2019\App\Cms\Pages\Request;

use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class UpdateTreePageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->instance()->ajax();
    }

    /**
     * Creador de validador para este Request
     * @return Validator El validador a usar
     */
    public function validator()
    {
        return Validator::make(
            json_decode(
                $this->instance()->getContent(),
                true /* Convertir a arreglo asociativo (con etiquetas) */
            ),
            $this->rules(),
            $this->messages(),
            $this->attributes()
        );
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            '*' => [
                'array',
                function ($attribute, $value, $fail) {
                    $this->validateTreeRecursively($attribute, $value, $fail);
                }
            ]
        ];
    }

    /**
     * Método privado para permitir la validación recursiva de los datos de jerarquía
     *
     * @param string    $attribute Nombre del atributo
     * @param mixed     $value     Valor del atributo
     * @param callable  $fail      Función anónima a ejecutar si $value no es correcto
     */
    private function validateTreeRecursively($attribute, $value, $fail, $pagesIds = null)
    {
        /* Variable para mantener contexto */
        $self = $this;

        /* Envolver arreglo en colección */
        $valueCollection = collect($value);

        /* Crear caché de IDs de páginas existentes para usar recursivamente */
        if (is_null($pagesIds)) {
            $pagesIds = Page::pluck('id');
        }

        if ($valueCollection->has('children')) {
            /* Hijos especificados, para mantener código DRY */
            $children = $valueCollection->get('children');

            if (!is_array($children)) {
                $fail("{$attribute}.children must be an array.");
            } else {
                /* Ciclar entre los hijos */
                collect($children)->each(function ($item, $key) use ($attribute, $fail, $pagesIds, $self) {
                    $self->validateTreeRecursively("{$attribute}.children.{$key}", $item, $fail, $pagesIds);
                });
            }
        }

        if ($valueCollection->has('id')) {
            /* ID especificada, para mantener código DRY */
            $id = $valueCollection->get('id');
            $intId = intval($id);

            if (!is_numeric($id)) {
                $fail("{$attribute}.id must be numeric.");
            } elseif ($intId != floatval($id)) {
                $fail("{$attribute}.id must be an integer.");
            } elseif (!$pagesIds->contains($intId)) {
                $fail("{$attribute}.id is not in our records.");
            }
        } else {
            $fail("{$attribute}.id must be present.");
        }
    }
}
