<?php

namespace AvengersMG\MGCms2019\App\Cms\Pages\Request;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateSeoPageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'locale' => [
                'required',
                Rule::in(app()->make('translatable.locales')->all())
            ],
            'meta_title' => 'present|nullable|max:191',
            'meta_description' => 'present|nullable|max:191',
        ];
    }
}
