<?php

namespace AvengersMG\MGCms2019\App\Cms\Pages\Request;

use AvengersMG\MGCms2019\App\Cms\Pages\Request\PageRequest;

/* Clase extiende a PageRequest para usar el método de validación de permalink */
class UpdatePageRequest extends PageRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'layout' => 'required',
            'name' => 'required',
            'title' => 'required',
            'status' => 'required',
            'slug' => 'required',
            'perman_link' => [
                function ($attribute, $value, $fail) {
                    $this->validateUniquePermalink($this->page->site, $attribute, $value, $fail, $this->page->id);
                }
            ],
        ];
    }
}
