<?php

namespace AvengersMG\MGCms2019\App\Cms\Pages\Request;

use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Cms\Pages\PageTranslation;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\DB;

class PageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'layout' => 'required',
            'template' => 'required',
            'name' => 'required',
            'title' => 'required',
            'status' => 'required',
            'parent_id' => 'nullable|exists:pages,id',
            'slug' => 'required',
            'perman_link' => [
                function ($attribute, $value, $fail) {
                    /* Establecer sitio */
                    $site = $this->route('site');

                    $site = (is_null($site))
                        ? Site::current()
                        : $site;

                    /* Último chequeo */
                    if (is_null($site)) {
                        $site = new Site();
                    }

                    $this->validateUniquePermalink($site, $attribute, $value, $fail);
                }
            ],
        ];
    }

    /**
     * Método protegido para la validación de permalinks únicos POR SITIO
     *
     * @param Site          $site             Sitio solicitado
     * @param string        $attribute        Nombre del atributo
     * @param mixed         $value            Valor del atributo
     * @param callable      $fail             Función anónima a ejecutar
     *                                        si $value no es correcto
     * @param int|string    $ignorePageId     ID de página a ignorar
     *                                        (no confundir con ID de traducción)
     * @return void
     */
    protected function validateUniquePermalink(Site $site, $attribute, $value, $fail, $ignorePageId = null)
    {
        if (!$site->exists) {
            $fail("Site ID is not in our records.");
        } else {
            /* Consulta para uso futuro */
            $queryPagesIds = Page::where('site_id', $site->id);

            /* Filtrar de acuerdo con el ID ignorado, si existe */
            $pagesIds = (is_null($ignorePageId))? $queryPagesIds->pluck('id')->all() : $queryPagesIds->where('id', '!=', $ignorePageId)->pluck('id')->all();

            if (PageTranslation::whereIn('page_id', $pagesIds)->where('perman_link', $value)->count() > 0) {
                $fail("{$attribute} is already being used.");
            }
        }
    }
}
