<?php

namespace AvengersMG\MGCms2019\App\Cms\Pages;

use Illuminate\Database\Eloquent\Model;

class Relation extends Model
{
    protected $fillable = ['page_id', 'related_page', 'name'];
    protected $table = 'page_relations';

    public function setNameAttribute($value)
    {
        $this->attributes['name'] = strtolower($value);
    }

    public function page()
    {
        return $this->hasOne(Page::class, 'id', 'related_page');
    }
}
