<?php

namespace AvengersMG\MGCms2019\App\Cms\Pages\Policies;

use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class PagePolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the page list.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function viewAny(User $user, Site $site)
    {
        /* Permitir si puede listar las páginas de todos los sitios o si es un sitio asignado */
        return $user->can('listar_paginas') || ($user->can('listar_paginas_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can view the page.
     *
     * @param  User $user
     * @param  Page $page
     * @return mixed
     */
    public function view(User $user, Page $page)
    {
        /* Permitir si puede ver todas las páginas o si la página es de un sitio asignado */
        return $user->can('ver_paginas') || ($user->can('ver_paginas_de_sitios_asignados') && ($user->sites->where('id', $page->site_id)->count() > 0));
    }

    /**
     * Determine whether the user can view pages from a site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function viewFromSite(User $user, Site $site)
    {
        /* Permitir si puede ver todas las páginas o si la página es de un sitio asignado */
        return $user->can('ver_paginas') || ($user->can('ver_paginas_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can create pages.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function create(User $user, Site $site)
    {
        /* Permitir si puede crear páginas para todos los sitios o si es un sitio asignado */
        return $user->can('crear_paginas') || ($user->can('crear_paginas_para_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can update the page.
     *
     * @param  User $user
     * @param  Page $page
     * @return mixed
     */
    public function update(User $user, Page $page)
    {
        /* Permitir si puede actualizar las páginas de todos los sitios o si es un sitio asignado */
        return $user->can('editar_paginas') || ($user->can('editar_paginas_de_sitios_asignados') && ($user->sites->where('id', $page->site_id)->count() > 0));
    }

    /**
     * Determine whether the user can update pages from the site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function updateFromSite(User $user, Site $site)
    {
        /* Permitir si puede actualizar las páginas del sitio o si es un sitio asignado */
        return $user->can('editar_paginas') || ($user->can('editar_paginas_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can delete the page.
     *
     * @param  User $user
     * @param  Page $page
     * @return mixed
     */
    public function delete(User $user, Page $page)
    {
        /* Permitir si puede eliminar las páginas de todos los sitios o si es un sitio asignado */
        return $user->can('eliminar_paginas') || ($user->can('eliminar_paginas_de_sitios_asignados') && ($user->sites->where('id', $page->site_id)->count() > 0));
    }

    /**
     * Determine whether the user can delete pages from the site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function deleteFromSite(User $user, Site $site)
    {
        /* Permitir si puede eliminar páginas de todos los sitios o si es un sitio asignado */
        return $user->can('eliminar_paginas') || ($user->can('eliminar_paginas_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }
}
