<?php

namespace AvengersMG\MGCms2019\App\Cms\Pages;

use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PageTranslation extends Model
{
    use SoftDeletes;

    public $timestamps = false;
    protected $fillable = ['name', 'title', 'sub_title', 'perman_link', 'description', 'excerpt', 'status', 'navigation', 'slug', 'meta_title', 'meta_description', 'seo'];

    /**
     * MUTADORES
     */

    public function setSlugAttribute($value)
    {
        if ($value != '/') {
            $this->attributes['slug'] = str_slug($value, '-');
        } else {
            $this->attributes['slug'] = $value;
        }
    }

    /**
     * Método público para establecer la relación con el modelo a traducir
     * 
     * @return  belongsTo Relación de pertenencia
     */
    public function page()
    {
        return $this->belongsTo(Page::class);
    }
}
