<?php

namespace AvengersMG\MGCms2019\App\Cms\Mediafiles\Request;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateMediafileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return $this->instance()->ajax();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required|string',
            'title' => 'sometimes|nullable',
            'description' => 'sometimes|nullable',
            'type_id' => 'nullable|string',
            'locale' => 'required|string',
            'status' => 'required|string',
            'path' => 'required|string|regex:/^.*\/[\w.-]+$/',
        ];
    }
}
