<?php

namespace AvengersMG\MGCms2019\App\Cms\Mediafiles\Policies;

use AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class MediafilePolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the mediafile list.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function viewAny(User $user, Site $site)
    {
        /* Permitir si puede listar los mediafiles */
        return $user->can('listar_mediafiles') || ($user->can('listar_mediafiles_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can view the mediafile.
     *
     * @param  User $user
     * @param  Mediafile $mediafile
     * @return mixed
     */
    public function view(User $user, Mediafile $mediafile)
    {
        /* Permitir si puede ver todos los mediafiles */
        return $user->can('ver_mediafiles') || ($user->can('ver_mediafiles_de_sitios_asignados') && ($user->sites->where('id', $mediafile->site->id)->count() > 0));
    }

    /**
     * Determine whether the user can view mediafiles from a site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function viewFromSite(User $user, Site $site)
    {
        /* Permitir si puede ver todos los mediafiles */
        return $user->can('ver_mediafiles') || ($user->can('ver_mediafiles_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can create mediafiles.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function create(User $user, Site $site)
    {
        /* Permitir si puede crear mediafiles */
        return $user->can('crear_mediafiles') || ($user->can('crear_mediafiles_para_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can create directories for mediafiles.
     *
     * @param  User $user
     * @return mixed
     */
    public function createDirectory(User $user)
    {
        /* Permitir si puede crear directorios */
        return $user->can('crear_directorios');
    }

    /**
     * Determine whether the user can update the mediafile.
     *
     * @param  User $user
     * @param  Mediafile $mediafile
     * @return mixed
     */
    public function update(User $user, Mediafile $mediafile)
    {
        /* Permitir si puede actualizar los mediafiles */
        return $user->can('editar_mediafiles') || ($user->can('editar_mediafiles_de_sitios_asignados') && ($user->sites->where('id', $mediafile->site->id)->count() > 0));
    }

    /**
     * Determine whether the user can update mediafiles from the site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function updateFromSite(User $user, Site $site)
    {
        /* Permitir si puede actualizar los mediafiles del sitio o si es un sitio asignado */
        return $user->can('editar_mediafiles') || ($user->can('editar_mediafiles_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }

    /**
     * Determine whether the user can delete the mediafile.
     *
     * @param  User $user
     * @param  Mediafile $mediafile
     * @return mixed
     */
    public function delete(User $user, Mediafile $mediafile)
    {
        /* Permitir si puede eliminar los mediafiles */
        return $user->can('eliminar_mediafiles') || ($user->can('eliminar_mediafiles_de_sitios_asignados') && ($user->sites->where('id', $mediafile->site->id)->count() > 0));
    }

    /**
     * Determine whether the user can delete mediafiles from the site.
     *
     * @param  User $user
     * @param  Site $site
     * @return mixed
     */
    public function deleteFromSite(User $user, Site $site)
    {
        /* Permitir si puede eliminar mediafiles de todos los sitios o si es un sitio asignado */
        return $user->can('eliminar_mediafiles') || ($user->can('eliminar_mediafiles_de_sitios_asignados') && ($user->sites->where('id', $site->id)->count() > 0));
    }
}
