<?php

namespace AvengersMG\MGCms2019\App\Cms\Mediafiles\Policies;

use AvengersMG\MGCms2019\App\Cms\Mediafiles\FileType;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class FileTypePolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the filetype list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todos los tipos */
        return $user->can('listar_tipos');
    }

    /**
     * Determine whether the user can view the filetype.
     *
     * @param  User $user
     * @param  FileType $filetype
     * @return mixed
     */
    public function view(User $user, FileType $filetype)
    {
        /* Permitir si puede ver todos los tipos */
        return $user->can('ver_tipos');
    }

    /**
     * Determine whether the user can create filetypes.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear tipos */
        return $user->can('crear_tipos');
    }

    /**
     * Determine whether the user can update the filetype.
     *
     * @param  User $user
     * @param  FileType $filetype
     * @return mixed
     */
    public function update(User $user, FileType $filetype)
    {
        /* Permitir si puede actualizar todos los tipos */
        return $user->can('editar_tipos');
    }

    /**
     * Determine whether the user can delete the filetype.
     *
     * @param  User $user
     * @param  FileType $filetype
     * @return mixed
     */
    public function delete(User $user, FileType $filetype)
    {
        /* Permitir si puede eliminar todos los tipos */
        return $user->can('eliminar_tipos');
    }
}
