<?php

namespace AvengersMG\MGCms2019\App\Cms\Mediafiles;

use Illuminate\Database\Eloquent\Model;

class FileType extends Model
{
    protected $fillable = ['type'];
    protected $table = 'file_types';

    /**
     * Nombres de los tipos de imágenes que son encabezados.
     *
     * Los valores pueden cambiar, pero los nombres de los índices
     * deben permanecer.
     *
     * @var string[]
     */
    protected static $headerNames = [
        'header' => 'slider_home',
        'header_mobile' => 'slider_home_mobile'
    ];

    public function setTypeAttribute($value)
    {
        $this->attributes['type'] = str_slug(mb_strtolower($value), '_');
    }

    /**
     * Método público estático que retorna el nombre de tipo "thumbnail"
     *
     * @return string Nombre actual de tipo "thumbnail"
     */
    public static function getThumbnailTypeName()
    {
        return 'thumbnail';
    }

    /**
     * Método público estático que retorna todos los tipos definidos
     * como encabezados
     *
     * @return string[] Nombres de tipos
     */
    public static function getAllHeaderTypeNames()
    {
        return static::$headerNames;
    }

    /**
     * Método público estático que retorna el nombre de tipo "header"
     *
     * @return string Nombre actual de tipo "header"
     */
    public static function getHeaderTypeName()
    {
        return static::$headerNames['header'];
    }

    /**
     * Método público estático que retorna el nombre de tipo "header_mobile"
     *
     * @return string Nombre actual de tipo "header_mobile"
     */
    public static function getHeaderMobileTypeName()
    {
        return static::$headerNames['header_mobile'];
    }

    /**
     * Método público estático que retorna el tipo "header_mobile"
     *
     * @return static Tipo "header_mobile"
     */
    public static function getHeaderMobile()
    {
        return static::where('type', static::getHeaderMobileTypeName())
            ->first();
    }

    /**
     * Método público estático que retorna el tipo "thumbnail"
     *
     * @return static Tipo "thumbnail"
     */
    public static function getThumbnail()
    {
        return static::where('type', static::getThumbnailTypeName())
            ->first();
    }

    /**
     * Método público estático que retorna el tipo "header"
     *
     * @return static Tipo "header"
     */
    public static function getHeader()
    {
        return static::where('type', static::getHeaderTypeName())
            ->first();
    }

    /**
     * Método público para crear ámbito para recuperar solo tipos de archivos
     * que representan encabezados
     *
     * @param  Builder $query Consulta inyectada
     * @return Builder        La consulta fitrada
     */
    public function scopeHeaders($query)
    {
        return $query->whereIn('type', static::$headerNames);
    }
}
