<?php

namespace AvengersMG\MGCms2019\App\Cms\Forms\Policies;

use AvengersMG\MGCms2019\App\Cms\Forms\FormRequest;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class FormRequestPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the form request list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todos los servicios de Viaggio */
        return $user->can('listar_servicios_de_viaggio');
    }

    /**
     * Determine whether the user can view the form request.
     *
     * @param  User $user
     * @param  FormRequest $formrequest
     * @return mixed
     */
    public function view(User $user, FormRequest $formrequest)
    {
        /* Permitir si puede ver todos los servicios de Viaggio */
        return $user->can('ver_servicios_de_viaggio');
    }

    /**
     * Determine whether the user can create form requests.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear servicios de Viaggio */
        return $user->can('crear_servicios_de_viaggio');
    }

    /**
     * Determine whether the user can update the form request.
     *
     * @param  User $user
     * @param  FormRequest $formrequest
     * @return mixed
     */
    public function update(User $user, FormRequest $formrequest)
    {
        /* Permitir si puede actualizar todos los servicios de Viaggio */
        return $user->can('editar_servicios_de_viaggio');
    }

    /**
     * Determine whether the user can delete the form request.
     *
     * @param  User $user
     * @param  FormRequest $formrequest
     * @return mixed
     */
    public function delete(User $user, FormRequest $formrequest)
    {
        /* Permitir si puede eliminar todos los servicios de Viaggio */
        return $user->can('eliminar_servicios_de_viaggio');
    }
}
