<?php

namespace AvengersMG\MGCms2019\App\Cms\Forms\Policies;

use AvengersMG\MGCms2019\App\Cms\Forms\Form;
use AvengersMG\MGCms2019\App\Cms\Users\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class FormPolicy
{
    use HandlesAuthorization;

    /**
     * Create a new policy instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine whether the user can view the form list.
     *
     * @param  User $user
     * @return mixed
     */
    public function viewAny(User $user)
    {
        /* Permitir si puede listar todas las formas */
        return $user->can('listar_formas');
    }

    /**
     * Determine whether the user can view the form.
     *
     * @param  User $user
     * @param  Form $form
     * @return mixed
     */
    public function view(User $user, Form $form)
    {
        /* Permitir si puede ver todas las formas */
        return $user->can('ver_formas');
    }

    /**
     * Determine whether the user can create forms.
     *
     * @param  User $user
     * @return mixed
     */
    public function create(User $user)
    {
        /* Permitir si puede crear formas */
        return $user->can('crear_formas');
    }

    /**
     * Determine whether the user can update the form.
     *
     * @param  User $user
     * @param  Form $form
     * @return mixed
     */
    public function update(User $user, Form $form)
    {
        /* Permitir si puede actualizar todas las formas */
        return $user->can('editar_formas');
    }

    /**
     * Determine whether the user can delete the form.
     *
     * @param  User $user
     * @param  Form $form
     * @return mixed
     */
    public function delete(User $user, Form $form)
    {
        /* Permitir si puede eliminar todas las formas */
        return $user->can('eliminar_formas');
    }
}
