<?php

namespace AvengersMG\MGCms2019\App\Cms\Forms;

use \Exception;
use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use Illuminate\Database\Eloquent\Model;

class FormsRepository extends BaseRepository implements FormsInterface
{
    public function __construct()
    {
        parent::__construct(Form::class);
    }

    public function create($request)
    {
        // dd($request->all());
        $mails = $request->email;
        $names = $request->user;
        $emails_bcc = $request->email_bcc;
        $names_bcc = $request->user_bcc;
        $recipients = $this->createArray($mails, $names,$emails_bcc, $names_bcc);

        /** Comprueba si el valor está establecido y no es null, si existe usa el valor,
         * de lo contrario establece el valor en 0
        **/
        $debug = (isset($request->debug)) ? $request->debug : 0;
        // dd($debug);

        if (!$recipients) {
            return false;
        }

        $params = [
            'name' => $request->name,
            'handler' => $request->handler,
            'recipients' => json_encode($recipients, true),
            'debug' => $debug
        ];
        

        call_user_func("{$this->model}::create", $params);
        return true;
    }

    public function update($request, $form = '')
    {
        $mails = $request->email;
        $names = $request->user;
        $emails_bcc = $request->email_bcc;
        $names_bcc = $request->user_bcc;
        $recipients = $this->createArray($mails, $names, $emails_bcc, $names_bcc);
        $debug = (isset($request->debug)) ? $request->debug : 0;
        //dd($debug);
        if (!$recipients) {
            return false;
        }

        $form->name = $request->name;
        $form->handler = $request->handler;
        $form->recipients = json_encode($recipients, true);
        $form->debug = $debug;
        $form->save();

        return true;
    }

    public function createArray($mails, $names, $emails_bcc, $names_bcc)
    {
        $recipients = [];
        $toMails = [];
        $bccMails = [];

        if (count(array_filter($mails)) == count(array_filter($names)) || count(array_filter($emails_bcc)) == count(array_filter($names_bcc))) {
            $toMails = array_map(function ($value, $i) use ($names) {
                if (!empty($value) && !empty($names[0])) {
                    return ['email' => $value, 'name' => $names[$i]];
                }

                return false;
            }, $mails, array_keys($mails));
            
            $array_to_mail = array_filter($toMails);
        }

        if (count(array_filter($emails_bcc)) == count(array_filter($names_bcc)) || count(array_filter($emails_bcc)) == count(array_filter($names_bcc))) {
            $bccMails = array_map(function ($value_bcc, $k) use ($names_bcc) {
                if (!empty($value_bcc) && !empty($names_bcc[0])) {
                    return ['email' => $value_bcc, 'name' => $names_bcc[$k]];
                }

                return false;
            }, $emails_bcc, array_keys($emails_bcc));

            $array_to_bccmail = array_filter($bccMails);
        }
        return $recipients = [$array_to_mail, $array_to_bccmail];

        return false;
    }

    /**
     * Función para recuperar los formatos de mail
     * @return string[] Arreglo de nombres de plantillas, con llaves de cadena
     */
    public function getMails()
    {
        $mails = [];

        try {
            $files = scandir(__DIR__.'/../../../app/Mail');

            foreach ($files as $i => $mail) {
                if (strpos($mail, 'php')) {
                    $string_parts = explode('.', $mail);
                    array_push($mails, [$string_parts[0] => $string_parts[0]]);
                }
            }
        } catch (Exception $e) {
            return [];
        }

        return collect($mails)->collapse();
    }
}
