<?php

/**
 * Created by PhpStorm.
 * User: MAC_82_MKT_Full_Stack
 * Date: 09/01/19
 * Time: 13:10
 */

namespace AvengersMG\MGCms2019\App\Cms\Components\Tours;

use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
// use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Illuminate\Support\Facades\DB;

class ToursRepository extends BaseRepository implements ToursInterface
{
    public function __construct()
    {
        parent::__construct(Tour::class);
    }

    /**
     * Método público para la creación de un nuevo tour
     * @param  mixed[] $params Información de datos desde el controlador
     * @return Tour            El tour creado
     */
    public function create($params)
    {
        app()->setLocale($params['locale']);

        return call_user_func("{$this->model}::create", $params);
    }

    public function prepareUpdate($request, $tour)
    {
        app()->setLocale($request->locale);
        $tour->update($request->all());
    }

    /**
     * Método público para la eliminación de tour y sus relaciones
     *
     * @param  Tour     $tour Tour a eliminar
     * @return boolean        Resultado de eliminación
     */
    public function deleteAll($tour)
    {
        $retorno = false;

        /* Iniciar transacción */
        DB::beginTransaction();

        try {
            /* Borrar traducciones y luego modelo */
            $tour->deleteTranslations();
            $tour->delete();

            /* Cambios realizados correctamente */
            DB::commit();

            /* Cambiar valor de retorno */
            $retorno = true;
        } catch (Exception $e) {
            /* Deshacer cambios */
            DB::rollback();
        }

        return $retorno;
    }
}
