<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Tours;

use Astrotomic\Translatable\Translatable;
use AvengersMG\MGCms2019\App\Cms\Components\Tours\TourTranslation;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use Illuminate\Database\Eloquent\Model;

class Tour extends Model
{
    use Translatable;

    protected $fillable = ['page_id'];
    protected $translatedAttributes = ['name', 'activity', 'recommendations', 'restriction', 'duration', 'short_description'];

    /**
     * Método para establecer la relación entre el tour y el objeto Page
     * @return BelongsTo Relación de pertenencia
     */
    public function page()
    {
        return $this->belongsTo(Page::class);
    }
}
