<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Specials;

use AvengersMG\MGCms2019\App\Cms\Components\Specials\SpecialTranslation;
use Illuminate\Database\Eloquent\Model;

class SpecialNotification extends Model
{
    public $timestamps = false;

    protected $table = "special_translation_notifications";

    protected $fillable = ['notification_time', 'special_translation_id'];

    protected $dates = [
        'notification_time',
        'created_at',
        'sent_at',
    ];

    /**
     * Método público para definir la relación de pertenencia de modelos
     * @return BelongsTo Relación de pertenencia
     */
    public function special_translation()
    {
        return $this->belongsTo(SpecialTranslation::class, 'special_translation_id');
    }
}