<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Services;

use AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service;
use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use Illuminate\Support\Facades\Storage;

class ServiceRepository extends BaseRepository implements ServiceInterface
{
    public function __construct()
    {
        parent::__construct(Service::class);
    }

    public function create($params)
    {
        if (isset($params->image)) {
            $file_name = $params->file('image')->getClientOriginalName();
            $path = $params->file('image')->storeAs('mediafiles/services/icons', $file_name, 'MGCms2019');

            $services = [
                'name' => $params->name,
                'name_es' => $params->name_es,
                'image' => $path,
                'icon' => $params->icon
            ];

            call_user_func("{$this->model}::create", $services);
        } else {
            call_user_func("{$this->model}::create", [
                'name' => $params['name'],
                'name_es' => $params['name_es'],
                'icon' => $params['icon']
            ]);
        }
    }

    public function update($params, $model = '')
    {
        $model->name = $params->name;
        $model->name_es = $params->name_es;
        if ($params->image) {
            Storage::disk('public')->delete($model->image);
            $file_name = $params->file('image')->getClientOriginalName();
            $model->image = $params->file('image')->storeAs('mediafiles/services/icons', $file_name, 'MGCms2019');
            $model->icon = null;
        }

        if ($params->icon) {
            Storage::disk('public')->delete($model->image);
            $model->image = null;
            $model->icon = $params->icon;
        }

        $model->save();
    }
}
