<?php

namespace AvengersMG\MGCms2019\App\Cms\Components\Restaurants;

use \Exception;
use AvengersMG\MGCms2019\App\Cms\BaseRepository\BaseRepository;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;

class RestaurantsRepository extends BaseRepository implements RestaurantsInterface
{
    public function __construct()
    {
        parent::__construct(Restaurant::class);
    }

    /**
     * Método público para crear un nuevo restaurante
     *
     * @param  mixed[]    $params Información proveniente del controlador
     * @return Restaurant         El restaurant creado
     */
    public function create($params)
    {
        $servicios_horarios = (Arr::has($params, ['servicio', 'servicio_es', 'open', 'close']))
            ? $this->createArray($params['servicio'], $params['servicio_es'], $params['open'], $params['close'], $params['locale'])
            : [];

        $arrayEnCode = json_encode($servicios_horarios, true);

        $data = [
            'page_id' => $params['page_id'],
            'open_hours' => $arrayEnCode,
            'locale' => $params['locale'],
            'name' => $params['name'],
            'title' => $params['title'],
            'subtitle' => $params['subtitle'],
            'body' => $params['body'],
        ];

        app()->setLocale($params['locale']);


        $restaurant = call_user_func("{$this->model}::create", $data);

        if (array_key_exists('services', $params)) {
            $restaurant->services()->attach($params['services']);
        }

        return $restaurant;
    }

    public function prepareUpdate($params, $restaurant)
    {
        $servicios_horarios = (Arr::has($params, ['servicio', 'open', 'close']))
            ? $this->createArray($params['servicio'], $params['servicio_es'], $params['open'], $params['close'], $params['locale'])
            : [];

        $arrayEnCode = json_encode($servicios_horarios, true);

        $data = [
            'page_id' => $params['page_id'],
            'open_hours' => $arrayEnCode,
            'locale' => $params['locale'],
            'name' => $params['name'],
            'title' => $params['title'],
            'subtitle' => $params['subtitle'],
            'body' => $params['body'],
        ];

        /* Verificar que la variable de menús existe */
        if (Arr::has($params, ['menus'])) {
            $data['menus'] = $params['menus'];
        }

        app()->setLocale($data['locale']);
        $restaurant->update($data);
        if (!array_key_exists('services', $data)) {
            $data['services'] = [];
        }

        $restaurant->services()->sync($data['services']);
    }

    /**
     * Método público para la eliminación de restaurante y sus relaciones
     *
     * @param  Restaurant     $restaurant Restaurante a eliminar
     * @return boolean                    Resultado de eliminación
     */
    public function deleteAll($restaurant)
    {
        $retorno = false;

        /* Iniciar transacción */
        DB::beginTransaction();

        try {
            /* Borrar traducciones y luego modelo */
            $restaurant->deleteTranslations();
            $restaurant->delete();

            /* Cambios realizados correctamente */
            DB::commit();

            /* Cambiar valor de retorno */
            $retorno = true;
        } catch (Exception $e) {
            /* Deshacer cambios */
            DB::rollback();
        }

        return $retorno;
    }

    public function createArray($servicio, $servicio_es, $open, $close) {
        $servicios_horarios = [];

        if (count(array_filter($servicio)) == count(array_filter($open)) ) {
            $servicios_horarios = array_map(function ($value, $i) use ($open, $close, $servicio_es) {
                if (!empty($value) && !empty($open[0]) && !empty($close[0])) {
                    return [
                            "servicio" => $value,
                            'servicio_es' => $servicio_es[$i],
                            "open" => $open[$i],
                            "close" => $close[$i]
                        //'capacidad' => $value, 'adultos' => $adultos[$i], 'ninos' => $ninos[$i]
                    ];
                }

                return false;
            }, $servicio, array_keys($servicio));
        }

        return array_filter($servicios_horarios);
    }
}
